/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.fabric.transfer;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.StoragePreconditions;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageUtil;
import net.fabricmc.fabric.api.transfer.v1.storage.TransferVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.base.SingleSlotStorage;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.fabricmc.fabric.api.transfer.v1.transaction.base.SnapshotParticipant;
import net.fabricmc.fabric.impl.transfer.DebugMessages;
import net.minecraft.class_1263;
import net.minecraft.class_1268;
import net.minecraft.class_1661;
import slimeknights.mantle.fabric.transfer.InventoryStorage;

class PlayerInventoryStorage
extends InventoryStorage {
    private final DroppedStacks droppedStacks = new DroppedStacks();
    private final class_1661 playerInventory;

    PlayerInventoryStorage(class_1661 playerInventory) {
        super((class_1263)playerInventory);
        this.playerInventory = playerInventory;
    }

    public long insert(ItemVariant resource, long maxAmount, TransactionContext transaction) {
        return this.offer(resource, maxAmount, transaction);
    }

    public long offer(ItemVariant resource, long amount, TransactionContext tx) {
        StoragePreconditions.notBlankNotNegative((TransferVariant)resource, (long)amount);
        long initialAmount = amount;
        List<SingleSlotStorage<ItemVariant>> mainSlots = this.getSlots().subList(0, 36);
        for (class_1268 hand : class_1268.values()) {
            SingleSlotStorage<ItemVariant> handSlot = this.getHandSlot(hand);
            if (!((ItemVariant)handSlot.getResource()).equals((Object)resource) || (amount -= handSlot.insert((Object)resource, amount, tx)) != 0L) continue;
            return initialAmount;
        }
        amount -= StorageUtil.insertStacking(mainSlots, (Object)resource, (long)amount, (TransactionContext)tx);
        return initialAmount - amount;
    }

    public void drop(ItemVariant variant, long amount, boolean throwRandomly, boolean retainOwnership, TransactionContext transaction) {
        StoragePreconditions.notBlankNotNegative((TransferVariant)variant, (long)amount);
        if (amount > 0L && !this.playerInventory.field_7546.method_37908().method_8608()) {
            this.droppedStacks.addDrop(variant, amount, throwRandomly, retainOwnership, transaction);
        }
    }

    public SingleSlotStorage<ItemVariant> getHandSlot(class_1268 hand) {
        if (Objects.requireNonNull(hand) == class_1268.field_5808) {
            if (class_1661.method_7380((int)this.playerInventory.field_7545)) {
                return this.getSlot(this.playerInventory.field_7545);
            }
            throw new RuntimeException("Unexpected player selected slot: " + this.playerInventory.field_7545);
        }
        if (hand == class_1268.field_5810) {
            return this.getSlot(40);
        }
        throw new UnsupportedOperationException("Unknown hand: " + String.valueOf(hand));
    }

    @Override
    public String toString() {
        return "PlayerInventoryStorage[" + DebugMessages.forInventory((class_1263)this.playerInventory) + "]";
    }

    public void drop(ItemVariant variant, long amount, boolean retainOwnership, TransactionContext transaction) {
        this.drop(variant, amount, false, retainOwnership, transaction);
    }

    public void drop(ItemVariant variant, long amount, TransactionContext transaction) {
        this.drop(variant, amount, false, transaction);
    }

    private class DroppedStacks
    extends SnapshotParticipant<Integer> {
        final List<Entry> entries = new ArrayList<Entry>();

        private DroppedStacks() {
        }

        void addDrop(ItemVariant key, long amount, boolean throwRandomly, boolean retainOwnership, TransactionContext transaction) {
            this.updateSnapshots(transaction);
            this.entries.add(new Entry(key, amount, throwRandomly, retainOwnership));
        }

        protected Integer createSnapshot() {
            return this.entries.size();
        }

        protected void readSnapshot(Integer snapshot) {
            int previousSize = snapshot;
            while (this.entries.size() > previousSize) {
                this.entries.remove(this.entries.size() - 1);
            }
        }

        protected void onFinalCommit() {
            for (Entry entry : this.entries) {
                int dropped;
                for (long remainder = entry.amount; remainder > 0L; remainder -= (long)dropped) {
                    dropped = (int)Math.min((long)entry.key.getItem().method_7882(), remainder);
                    PlayerInventoryStorage.this.playerInventory.field_7546.method_7329(entry.key.toStack(dropped), entry.throwRandomly, entry.retainOwnership);
                }
            }
            this.entries.clear();
        }

        private record Entry(ItemVariant key, long amount, boolean throwRandomly, boolean retainOwnership) {
        }
    }
}

